/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictionaryHelper {
    public static final Converter<String, String> UPPER_UNDERSCORE_TO_LOWER_CAMEL = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
    public static final Joiner JOINER_UNDERSCORE = Joiner.on((char)'_').skipNulls();
    private static final Multimap<Element, String> MAP = LinkedListMultimap.create();
    private static boolean pastInit = false;

    public static void init() {
        if (!pastInit) {
            for (Map.Entry entry : MAP.entries()) {
                OreDictionary.registerOre((String)((String)entry.getValue()), (ItemStack)((Element)entry.getKey()).toStack());
            }
            MAP.clear();
            pastInit = true;
        }
    }

    public static void register(Block element, Object ... parts) {
        if (pastInit) {
            OreDictionary.registerOre((String)OreDictionaryHelper.toString(parts), (ItemStack)new ItemStack(element, 1, Short.MAX_VALUE));
        } else {
            MAP.put((Object)new Element(element), (Object)OreDictionaryHelper.toString(parts));
        }
    }

    public static void register(Item element, Object ... parts) {
        if (pastInit) {
            OreDictionary.registerOre((String)OreDictionaryHelper.toString(parts), (ItemStack)new ItemStack(element, 1, Short.MAX_VALUE));
        } else {
            MAP.put((Object)new Element(element), (Object)OreDictionaryHelper.toString(parts));
        }
    }

    public static void register(ItemStack element, Object ... parts) {
        if (pastInit) {
            OreDictionary.registerOre((String)OreDictionaryHelper.toString(parts), (ItemStack)element);
        } else {
            MAP.put((Object)new Element(element.func_77973_b(), element.func_77960_j()), (Object)OreDictionaryHelper.toString(parts));
        }
    }

    private static String toString(Object ... parts) {
        return (String)UPPER_UNDERSCORE_TO_LOWER_CAMEL.convert((Object)JOINER_UNDERSCORE.join(parts));
    }

    private OreDictionaryHelper() {
    }

    private static class Element {
        private Block block;
        private Item item;
        private int meta;

        private Element(Item item, int meta) {
            this.item = item;
            this.meta = meta;
        }

        private Element(Item item) {
            this(item, -1);
        }

        private Element(Block block) {
            this.block = block;
        }

        private ItemStack toStack() {
            if (this.block != null) {
                return new ItemStack(this.block);
            }
            if (this.item != null) {
                return this.meta == -1 ? new ItemStack(this.item, 1, Short.MAX_VALUE) : new ItemStack(this.item, this.meta);
            }
            return ItemStack.field_190927_a;
        }
    }
}

